using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace [!Namespace]
{
	/// <summary>
	/// Summary description for [!FormName].
	/// </summary>
	public class [!FormName] : System.Web.Services.WebService
	{
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private [!EcoSpaceClassName] m_EcoSpace;
		private [!EcoSpaceClassName] EcoSpace
		{
			get
			{
				if (m_EcoSpace == null)
				{
					m_EcoSpace = EcoSpaceProvider.GetSessionFreeEcoSpace();
					rhRoot.EcoSpace = m_EcoSpace;
				}
				return m_EcoSpace;
			}
		}

		private void DoneWithEcoSpace()
		{
			if (m_EcoSpace == null)
				return;
			rhRoot.EcoSpace = null;
			rhRoot.SetElement(null);
			// Clear all other references to m_EcoSpace or it's contents here.
			// Otherwise it is not safe to return it to a pool.

			EcoSpaceProvider.ReturnSessionFreeEcoSpace(m_EcoSpace);
			m_EcoSpace = null;
		}

		public [!FormName]()
		{
			//
			// This call is required by the Designer
			//
			InitializeComponent();
		}


		#region Web Form Designer generated code

		//Required by the Web Services Designer
		private IContainer components = null;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			// 
			// rhRoot
			// 
			this.rhRoot.Enabled = true;
			this.rhRoot.EcoSpace = null;
			this.rhRoot.StaticValueTypeName = null;
			this.rhRoot.Variables = null;
[!if=(EcoSpaceClassName, "Borland.Eco.Handles.EcoSpace")]
[!else]
			this.rhRoot.EcoSpaceType = typeof([!Namespace].[!EcoSpaceClassName]);
[!endif]
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		#endregion

		#region Utility methods
		protected void UpdateDatabase()
		{
			IPersistenceService persistenceService = EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
			IDirtyListService dirtyListService = EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
			persistenceService.UpdateDatabaseWithList(dirtyListService.AllDirtyObjects());
		}

		protected string IdForObject(IObject obj)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.IdForObject(obj);
		}

		protected IObjectInstance ObjectForId(string id)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.ObjectForId(id);
		}
		#endregion

		// Sample Web Service Methods
		// The following methods are provided to allow for testing a new web service.
		// To test, uncomment these lines, save, and build the project.
		// This code may safely be deleted.

		/*
		[WebMethod]
		public string HelloWorld()
		{
			return "Hello World";
		}


		// This is a minimal web method reading data
		// It assumes an ECO model containing a Class named Order
		[WebMethod]
		int OrderCount()
		{
			IOclService oclService = (IOclService)EcoSpace.GetEcoService(typeof(IOclService));
			IElement resultElement = oclService.EvaluateAndSubscribe(null, "Order.allInstances->size", null, null);
			int result = (int)resultElement.AsObject;
			DoneWithEcoSpace();
			return result;
		}

		// This is a minimal web method modifying data
		// It assumes an ECO model containing a Class named Order
		// with an attribute Order.CustomerName

		[WebMethod]
		void NewOrder(string name)
		{
			Order anOrder = new Order(EcoSpace);
			anOrder.CustomerName = name;
			UpdateDatabase();
			DoneWithEcoSpace();
		}
		*/

	}
}
